﻿
package edu.unl.astro.starField {
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Rectangle;
	import flash.geom.Point;
	import flash.utils.getTimer;
	import flash.utils.ByteArray;
	import flash.events.Event;

	public class StarField extends Sprite {
		
		private var _width:Number;
		private var _height:Number;
		
		private var _noiseMean:Number;
		private var _noiseSigma:Number;
		private var _noiseSeed:uint = 1;
		
		private var _saturationMagnitude:Number;
		private var _bitDepth:uint;
		private var _peakValue:Number; // := 2^bitDepth - 1
		
		
		private var _mappingMode:String = "linear";
		private var _invertMapping:Boolean = false;
		private var _gamma:Number = 1.8;		
		//private var _lookupTable:Array;
		
		private var _starsList:Array;
		
		
		// - _noiseData is an array of the noise values that were calculated when
		//   the noise profile was specified; it can be divided into _numChunks segments
		//   each of which has _chunkSize values
		// - noisePixels is a byte array consisting of 0xAARRGGBB (uint) pixel values
		//   corresponding to the values in noiseSource mapped according to the current settings
		private var _noiseData:Array;
		private var _noisePixels:ByteArray;
		
		// - fieldData is a byte array consisting of the field data (ie. the counts) 
		//   in *floating point* format
		// - fieldPixels is a byte array consisting of the values
		private var _fieldDataS:Array;
		private var _fieldPixels:ByteArray;
		
		private var _fieldBMD:BitmapData;
		private var _fieldBM:Bitmap;
		
		private var _fieldRect:Rectangle;
		
		private var _locked:Boolean = false;
		
		private var _numChunks:int;
		private var _chunkSize:int;
		
		private var _chunkTable:Array;
		
		
		
		private var _epoch:Number = 0;
		private var _shuffleSeed:uint;
		
		
		
		public function StarField():void {
			
			_starsList = new Array();
			//_customMappingKeysList = new Array();
			_fieldDataS = new Array();
			_noiseData = new Array();
			_noisePixels = new ByteArray();
			_fieldPixels = new ByteArray();
			//_lookupTable = new Array();
			
			var startTimer:Number = getTimer();
			
			
			var w:int = 450;
			var h:int = 350;
			
			_width = w;
			_height = h;
			
			_fieldBMD = new BitmapData(w, h, false, 0xff0000);
			_fieldBM = new Bitmap(_fieldBMD);
			addChild(_fieldBM);
			
			_fieldRect = new Rectangle(0, 0, w, h);
			
			_numChunks = 0.7*w;
			_chunkSize = Math.ceil((w*h)/_numChunks);
			if ((_chunkSize%2)==1) _chunkSize += 1;
			
			_chunkTable = new Array(_numChunks);
			
			
			
			
			
			
			
			
			lock();
			
			bitDepth = 16;
			saturationMagnitude = 3;
			
			noiseMean = 0;
			noiseSigma = 5000;
			
			
			generateNoise();
			//generateLookupTable();
			generateNoisePixels();
			
			unlock();
			trace("constructor: "+(getTimer()-startTimer));
		}
		
		private var totalUpdates:int = 0;
		private var totalUpdateTime:int = 0;
		
		private function update(...argsIgnored):void {
			if (_locked) return;
			
			if (_transferFunction==null) return;

			
			var startTimer:Number = getTimer();
			
			shuffleChunkTable();
			copyNoisePixels();
			
			_fieldDataS = _noiseData.concat();
			
			//trace("TF is null: "+(_transferFunction==null));
			
			var star:IStar;
			var psfCol:Array;
			
			// left an top denote the position of the upper left corner of the psf template for a star
			var left:int;
			var top:int;
			
			// f is the psf scaling factor for a given star
			var f:Number;
			
			// x and y are the field coordinates for a given point corresponding to template coordinates j and k
			var x:int;
			var y:int;
			
			// m, p, and q are used to get the corresponding point in the scrambled field data array,
			var m:int;
			var p:int;
			var q:int;
			
			// u is the value of the psf template at a given point and v is the value of the 
			// star field at that given point (after adding the psf contribution for the star)
			var u:Number;
			var v:Number;
			
			// now we are ready to go through the stars list and add each to the star field
			for (var i:int = 0; i<_starsList.length; i++) {
				star = _starsList[i];
				star.epoch = _epoch;
				f = _peakValue*Math.pow(10, (_saturationMagnitude - star.magnitude)/2.5);
				left = star.x - _psf.x;
				top = star.y - _psf.y;
				
				// now go through the pixels of the psf template and scale and place the values for the given star
				for (var j:int = 0; j<_psf.width; j++) {
					x = left + j;
					if (x<0) continue;
					else if (x>=_width) break;
					psfCol = _psf.data[j];
					for (var k:int = 0; k<_psf.height; k++) {
						y = top + k;
						u = psfCol[k];
						if (u<=0 || y<0) continue;
						else if (y>=_height) break;
						m = x + y*_width;
						p = m/_chunkSize;
						q = m - p*_chunkSize;
						v = (_fieldDataS[int(q+_chunkSize*_chunkTable[p])] += f*u);
						if (v<0) v = 0;
						else if (v>_peakValue) v = _peakValue;
						_fieldPixels.position = 4*m;
						_fieldPixels.writeUnsignedInt(_transferFunction.getColor(uint(v)));
				//		_fieldPixels.writeUnsignedInt(_lookupTable[int(v)]);
					}
				}
			}
			
			_fieldPixels.position = 0;
			_fieldBMD.setPixels(_fieldRect, _fieldPixels);
			
			dispatchEvent(new Event("fieldUpdated"));
			
			var t:Number = getTimer() - startTimer;
			totalUpdateTime += t;
			totalUpdates++;
			
			trace("update: "+t);
			trace("average: "+(totalUpdateTime/totalUpdates));			
		}
		
		
		
		
		
		
		
		
		
		
		public function get locked():Boolean {
			return _locked;
		}
		
		public function set locked(arg:Boolean):void {
			arg ? lock() : unlock();
		}
		
		public function lock():void {
			_fieldBM.visible = false;
			_locked = true;
		}
		
		public function unlock():void {
			_fieldBM.visible = true;
			_locked = false;
			update();		
		}
		
		
		
		
		
		
		
		
		
		
		
		public function addStar(star:IStar):void {
			star.addEventListener(StarField.STAR_CHANGED, update);
			_starsList.push(star);
			update();
		}
		
		public function removeStar(star:IStar):Boolean {
			for (var i:int = 0; i<_starsList.length; i++) {
				if (star==_starsList[i]) {
					star.removeEventListener(StarField.STAR_CHANGED, update);
					_starsList.splice(i, 1);
					update();
					return true;
				}
			}
			return false;
		}
		
		public function removeAllStars():void {
			for (var i:int = 0; i<_starsList.length; i++) {
				_starsList[i].removeEventListener(StarField.STAR_CHANGED, update);
			}
			_starsList = [];
			update();
		}
		
		public function get saturationMagnitude():Number {
			return _saturationMagnitude;
		}
		
		public function set saturationMagnitude(mag:Number):void {
			if (!isFinite(mag) || isNaN(mag)) return;
			_saturationMagnitude = mag;
			update();
		}
		
		public function get bitDepth():uint {
			return _bitDepth;			
		}
		
		public function set bitDepth(depth:uint):void {
			if (depth>16 || depth<2) return;
			_bitDepth = depth;
			_peakValue = Math.pow(2, _bitDepth) - 1;
			
			if (_transferFunction!=null) _transferFunction.peakValue = _peakValue;
			
			//dispatchEvent(new Event(StarField.BIT_DEPTH_CHANGED));
			
			//generateLookupTable();
			//generateNoisePixels();
			
			//update();
		}
		
		public function get peakValue():uint {
			return _peakValue;			
		}
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		public function get epoch():Number {
			return _epoch;			
		}
		
		public function set epoch(arg:Number):void {
			if (!isFinite(arg) || isNaN(arg)) return;
			_epoch = arg;
			_shuffleSeed = 1 + 0x7ffffffe*Math.random();
			update();
		}
		
		public function get noiseSeed():uint {
			return _shuffleSeed;
		}
		
		public function set noiseSeed(seed:uint):void {
			if (!isFinite(seed) || isNaN(seed) || seed<1 || seed>0x7ffffffe) return;
			_shuffleSeed = seed;
			update();
		}
		
		public function setEpochAndNoiseSeed(e:Number, seed:uint):void {
			if (!isFinite(e) || isNaN(e)) return;
			if (!isFinite(seed) || isNaN(seed) || seed<1 || seed>0x7ffffffe) return;
			_epoch = e;
			_shuffleSeed = seed;
			update();
		}
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		public function get noiseMean():Number {
			return _noiseMean;			
		}
		
		public function set noiseMean(arg:Number):void {
			_noiseMean = arg;
			
			generateNoise();
			generateNoisePixels();
			update();		
		}
		
		public function get noiseSigma():Number { 
			return _noiseSigma;		
		}
		
		public function set noiseSigma(arg:Number):void {
			_noiseSigma = arg;
			
			generateNoise();
			generateNoisePixels();
			update();
		}
		
		
		
		public static const TRANSFER_FUNCTION_CHANGED:String = "transferFunctionChanged";
		public static const BIT_DEPTH_CHANGED:String = "bitDepthChanged";
		
		
		private var _transferFunction:ITransferFunction;
		
		public function get transferFunction():ITransferFunction {
			return _transferFunction;
		}
		
		public function set transferFunction(arg:ITransferFunction):void {
			if (_transferFunction!=null) _transferFunction.removeEventListener(StarField.TRANSFER_FUNCTION_CHANGED, update2);
			_transferFunction = arg;
			
			// fix
			_transferFunction.peakValue = _peakValue;
			
			_transferFunction.addEventListener(StarField.TRANSFER_FUNCTION_CHANGED, update2);
			update2();
		}
		
		private function update2(...ignored):void {
			trace("");
			generateNoisePixels();
			update();
		}
	
		/*
		
		public static const LINEAR:String = "linear";
		public static const GAMMA:String = "gamma";
		
		public function get mappingMode():String {
			return _mappingMode;			
		}
		
		public function set mappingMode(arg:String):void {
			if (arg!=StarField.LINEAR && arg!=StarField.GAMMA) return;
			_mappingMode = arg;
			//generateLookupTable();
			generateNoisePixels();
			update();
		}
		
		public function get invertMapping():Boolean {
			return _invertMapping;			
		}
		
		public function set invertMapping(arg:Boolean):void {
			_invertMapping = arg;
			generateLookupTable();
			generateNoisePixels();
			update();		
		}
		
		public function get gamma():Number {
			return _gamma;
		}
		
		public function set gamma(arg:Number):void {
			if (isNaN(arg) || !isFinite(arg) || arg<=0) return;
			_gamma = arg;
			if (_mappingMode==StarField.GAMMA) {
				generateLookupTable();
				generateNoisePixels();
				update();
			}
		}
	
		private function generateLookupTable():void {
			// - this function generates a lookup table which takes a value (the index) and
			//   returns the corresponding uint (0xaarrggbb) pixel value
			var startTimer:Number = getTimer();
			
			var i:int;
			var g:int;
			var n:int = _peakValue + 1;
			var k:Number = 0xff/_peakValue;
			
			if (_invertMapping) {
				if (_mappingMode=="linear") {
					for (i=0; i<n; i++) {
						g = 0xff - int(k*i);
						_lookupTable[i] = uint(0xff000000 | (g << 16) | (g << 8) | g);						
					}
				}
				else if (_mappingMode=="gamma") {
					for (i=0; i<n; i++) {
						g = 0xff - 0xff*Math.pow(i/_peakValue, 1/_gamma);
						_lookupTable[i] = uint(0xff000000 | (g << 16) | (g << 8) | g);	
					}
				}
			}
			else {
				if (_mappingMode=="linear") {
					for (i=0; i<n; i++) {
						g = k*i;
						_lookupTable[i] = uint(0xff000000 | (g << 16) | (g << 8) | g);					
					}
				}
				else if (_mappingMode=="gamma") {
					for (i=0; i<n; i++) {
						g = 0xff*Math.pow(i/_peakValue, 1/_gamma);
						_lookupTable[i] = uint(0xff000000 | (g << 16) | (g << 8) | g);	
					}
				}
			}
			
			var key:Object;
			for (i=0; i<_customMappingKeysList.length; i++) {
				key = _customMappingKeysList[i];
				if (key.value>=0 && key.value<=_peakValue) {
					_lookupTable[key.value] = key.color;					
				}			
			}
			
			trace("generateLookupTable: "+(getTimer()-startTimer)+" ("+_mappingMode+")");
		}
		
		*/
		
		
		
		
		
		
		
		
		
		private function generateNoise():void {
			var startTimer:Number = getTimer();
			var f:Number;
			var x1:Number;
			var x2:Number;
			var i:int;
			var n:int = _numChunks*_chunkSize;
			var seed:uint = _noiseSeed;
			for (i=0; i<n; i++) {
				do {
					x1 = 2*(seed/2147483647) - 1;
					seed = (seed*16807)%2147483647;
					x2 = 2*(seed/2147483647) - 1;
					seed = (seed*16807)%2147483647;
					f = x1*x1 + x2*x2;
				} while (f>=1);
				f = Math.sqrt((-2*Math.log(f))/f);
				_noiseData[i] = _noiseMean + _noiseSigma*x1*f;
				_noiseData[++i] = _noiseMean + _noiseSigma*x2*f;
			}	
		}
		
		private function generateNoisePixels():void {
			if (_transferFunction==null) return;
			
			// - this function maps the values in the noise source array to an array of uint (0xaarrggbb)
			//   pixel values according to the current lookup table; the point of this is to save some
			//   time looking up pixel values since most of the field is unmodified noise
			var startTimer:Number = getTimer();
			var i:int;
			var v:int;
			var n:int = _numChunks*_chunkSize;
			_noisePixels.position = 0;
			for (i=0; i<n; i++) {
				v = _noiseData[i];
				if (v<0) v = 0;
				else if (v>_peakValue) v = _peakValue;
				_noisePixels.writeUnsignedInt(_transferFunction.getColor(uint(v)));
			}
			//_noisePixels.writeUnsignedInt(_lookupTable[int(v)]);
			//_fieldPixels.writeUnsignedInt(_transferFunction.getColor(uint(v)));
			//_fieldPixels.writeUnsignedInt(_lookupTable[int(v)]);
		}
		
		private function shuffleChunkTable():void {
			// - this function shuffles the _chunkTable array, which specifies
			//   the order in which the noise chunks are assembled to create the
			//   noise background for a particular frame
			var startTimer:Number = getTimer();
			var i:int;
			var j:int;
			var tmp:int;
			var seed:uint = _shuffleSeed;//1 + 0x7ffffffe*Math.random();
			for (i=0; i<_numChunks; i++) _chunkTable[i] = i;
			for (i=0; i<_numChunks-1; i++) {
				j = i + int((_numChunks-i)*(seed/2147483647));
				seed = (seed*16807)%2147483647;
				tmp = _chunkTable[j];
				_chunkTable[j] = _chunkTable[i];
				_chunkTable[i] = tmp;
			}
		}

		private function copyNoisePixels():void {
			var startTimer:Number = getTimer();
			var i:int;
			_fieldPixels.position = 0;
			var k:int = 4*_chunkSize;
			for (i=0; i<_numChunks; i++) {
				_noisePixels.position = k*_chunkTable[i];
				_noisePixels.readBytes(_fieldPixels, i*k, k);
			}
		}
		
		
		
		/*
		
		private var _customMappingKeysList:Array;
		
		public function addCustomMappingKey(value:int, color:uint):void {
			_customMappingKeysList.push({value: value, color: color});
			generateLookupTable();
			generateNoisePixels();
			update();		
		}
		
		public function removeCustomMappingKeys():void {
			_customMappingKeysList = [];			
			generateLookupTable();
			generateNoisePixels();
			update();		
		}
		
		*/
		
		
		
		
		
		
		private var _psf:IPSF;
		public static const STAR_CHANGED:String = "starChanged";
		public static const PSF_CHANGED:String = "psfChanged";
		
		public function get psf():IPSF {
			return _psf;
		}	
		
		public function set psf(arg:IPSF):void {			
			if (_psf!=null) _psf.removeEventListener(StarField.PSF_CHANGED, update);
			_psf = arg;
			_psf.addEventListener(StarField.PSF_CHANGED, update);
			update();			
		}
		
		
		
		private var _nonColor:uint = 0x00ffcc00;
		
		
		
		
		
		
		
		
		
		
		public function getStatistics(pMask:IPixelMask):Object {
			// given a pixel mask object, this function returns an object with the following properties:
			//   totalCounts - the number of counts for every pixel covered by the mask
			//   totalPixels - the number of pixels actually in the field covered by the mask
			//   clipped - a Boolean indicating whethere there are pixels that are part of the mask
			//             but not part of the field (ie. the mask is over the edge of the image)
			//   average - the average counts per pixel covered by the mask: totalCounts/totalPixels 
			var j:int;
			var k:int;
			var x:int;
			var y:int;
			var m:int;
			var p:int;
			var q:int;
			var v:Number;
			var clipped:Boolean = false;
			var totalCounts:uint = 0;
			var totalPixels:uint = 0;
			for (j=0; j<pMask.width; j++) {
				x = pMask.left + j;
				if (x<0) {
					clipped = true;
					continue;
				}
				else if (x>=_width) {
					clipped = true;
					break;
				}
				for (k=0; k<pMask.height; k++) {
					y = pMask.top + k;
					if (y<0) {
						clipped = true;
						continue;
					}
					else if (y>=_height) {
						clipped = true;
						break;
					}
					if (pMask.data[j][k]) {
						m = x + y*_width;
						p = m/_chunkSize;
						q = m - p*_chunkSize;
						v = _fieldDataS[int(q+_chunkSize*_chunkTable[p])];
						if (v<0) v = 0;
						else if (v>_peakValue) v = _peakValue;
						totalCounts += uint(v);
						totalPixels++;
					}
				}
			}
			var obj:Object = {};
			obj.totalCounts = totalCounts;
			obj.totalPixels = totalPixels;
			obj.clipped = clipped;
			obj.average = obj.totalCounts/obj.totalPixels;
			return obj;			
		}
		
		public function getPixelColors(rect:Rectangle):Array {
			// - this function returns a two dimensional array of uint pixel values 
			//   for the specified region; parts of the region outside the field
			//   will have value 0x00000000 (note the alpha channel is zero, where
			//   it would normally be 0xff, unless a custom mapping key specifies otherwise)
			// - the region includes the top and left boundaries of the pixel, but not the 
			//   right and bottom boundaries
			var pixels:Array = [];
			var i:int;
			var x:int;
			var y:int;
			var m:int;
			var p:int;
			var q:int;
			var v:Number;
			var col:Array;
			for (x=rect.left; x<rect.right; x++) {
				col = [];
				if (x<0 || x>=_width) {
					// the column is out of bounds
					for (i=0; i<rect.height; i++) col[i] = _nonColor;
				}
				else {
					for (y=rect.top; y<rect.bottom; y++) {
						if (y<0 || y>=_height) {
							// the pixel is out of bounds
							col.push(_nonColor);
						}
						else {
							m = x + y*_width;
							p = m/_chunkSize;
							q = m - p*_chunkSize;
							v = _fieldDataS[int(q+_chunkSize*_chunkTable[p])];
							if (v<0) v = 0;
							else if (v>_peakValue) v = _peakValue;
							//col.push(_lookupTable[int(v)]);
							col.push(_transferFunction.getColor(int(v)));
						}					
					}
				}
				pixels.push(col);				
			}
			return pixels;
		}
		
		public function getPixelInfo(pt:Point):Object {
			// - this function can be used to the counts and color for a given pixel; the function
			//   returns an object with the following properties:
			//      counts:int - the number of counts for the pixel; it will be -1 if the given
			//                   pixel is outside the bounds of the field
			//      color:uint - the color the pixel according to the lookup table
			if (pt.x<0 || pt.x>=_width || pt.y<0 || pt.y>=_height) {
				return {counts: int(-1), color: _nonColor};
			}
			var m:int = pt.x + pt.y*_width;
			var p:int = m/_chunkSize;
			var q:int = m - p*_chunkSize;
			var v:Number = _fieldDataS[int(q+_chunkSize*_chunkTable[p])];
			if (v<0) v = 0;
			else if (v>_peakValue) v = _peakValue;
			return {count: int(v), color: _transferFunction.getColor(int(v))};
			//return {counts: int(v), color: _lookupTable[int(v)]};
		}
		
	}
}
