﻿
package edu.unl.astro.starField {
	
	import flash.events.Event;
	import flash.events.EventDispatcher;
	
	public class PulsatingStar extends EventDispatcher implements IStar {
		
		private var _phaseOffset:Number = 0;
		private var _period:Number = 3;
		private var _functionUsed:String = PulsatingStar.COSINE;
		private var _paramsObj:StarParamsObject;
		private var _termsList:Array;
		private var _A0:Number = 0;
		
		public static const COSINE = "cos";
		public static const SINE = "sin";
		
		
		
		
		public static const systemsList:Array = [
			{name: "del Cep", type: "Cepheid, DCEP", period: 5.366341, functionUsed: "cos", magnitude: 3.988, fourierTermsList: [{A: 3.496E-01, phi: 2.491}, {A: 1.385E-01, phi: 3.084}, {A: 5.499E-02, phi: 3.811}, {A: 2.277E-02, phi: 4.083}, {A: 9.765E-03, phi: 4.709}]},
			{name: "RT Mus", type: "Cepheid, DCEP", period: 3.08617, functionUsed: "cos", magnitude: 9.03, fourierTermsList: [{A: 0.331, phi: 0.0277}, {A: 0.131, phi: 4.13}, {A: 0.0503, phi: 2.24}, {A: 0.0416, phi: 6.16}]},
			{name: "AS Per", type: "Cepheid, DCEP", period: 4.972516, functionUsed: "cos", magnitude: 9.760, fourierTermsList: [{A: 3.583E-01, phi: 2.468}, {A: 1.443E-01, phi: 3.084}, {A: 5.731E-02, phi: 3.650}, {A: 2.603E-02, phi: 3.695}, {A: 2.110E-02, phi: 4.625}]},
			{name: "S Nor", type: "Cepheid, DCEP", period: 9.75411, functionUsed: "cos", magnitude: 6.4354, fourierTermsList: [{A: 0.2874, phi: 3.1842}, {A: 0.0191, phi: 4.6142}, {A: 0.0296, phi: 2.7042}, {A: 0.0144, phi: 3.3482}, {A: 0.0180, phi: 3.0182}, {A: 0.0159, phi: 3.4322}]},
			{name: "PZ Aql", type: "Cepheid, CWA", period: 8.7513, functionUsed: "cos", magnitude: 11.7, fourierTermsList: [{A: 0.365, phi: 4.66}, {A: 0.0459, phi: 1.75}, {A: 0.0208, phi: 2.76}, {A: 0.0188, phi: 5.98}]},
			{name: "MT Tel", type: "RR Lyrae, RRC", period: 0.316897, functionUsed: "cos", magnitude: 9.01, fourierTermsList: [{A: 2.60e-1, phi: 1.93}, {A: 7.35e-2, phi: 1.89}, {A: 1.66e-2, phi: 1.85}, {A: 1.00e-2, phi: 1.95}, {A: 5.60e-3, phi: 1.35}, {A: 4.89e-3, phi: 1.48}, {A: 4.53e-3, phi: 1.62}, {A: 1.51e-3, phi: 1.11}]},
			{name: "RR Leo", type: "RR Lyrae, RRAB", period: 0.4523933, functionUsed: "cos", magnitude: 10.83, fourierTermsList: [{A: 4.55e-1, phi: 6.91e-1}, {A: 2.28e-1, phi: 5.16}, {A: 1.61e-1, phi: 3.69}, {A: 9.91e-2, phi: 2.33}, {A: 7.79e-2, phi: 1.02}, {A: 4.91e-2, phi: 5.81}, {A: 3.27e-2, phi: 4.45}, {A: 3.14e-2, phi: 2.97}]},
			{name: "VX Her", type: "RR Lyrae, RRAB", period: 0.45537282, functionUsed: "cos", magnitude: 10.78, fourierTermsList: [{A: 4.58e-1, phi: 4.51}, {A: 2.12e-1, phi: 2.61e-1}, {A: 1.64e-1, phi: 2.56}, {A: 1.06e-1, phi: 4.96}, {A: 7.33e-2, phi: 1.07}, {A: 5.92e-2, phi: 3.57}, {A: 3.62e-2, phi: 6.07}, {A: 2.70e-2, phi: 2.20}]}];

		
		
		
		
		public function PulsatingStar(initX:Number = 0, initY:Number = 0, initMagnitude:Number = 0, initTermsList:* = null):void {
			_A0 = initMagnitude;
			_paramsObj = new StarParamsObject(initX, initY, initMagnitude);
			if (initTermsList is Array) setFourierTermsList(initTermsList);
		}
		
		public function get x():Number {
			return _paramsObj.x;
		}
		
		public function set x(arg:Number):void {
			_paramsObj.x = arg;
			dispatchEvent(new Event(StarField.STAR_CHANGED));
		}
		
		public function get y():Number {
			return _paramsObj.y;
		}
		
		public function set y(arg:Number):void {
			_paramsObj.y = arg;
			dispatchEvent(new Event(StarField.STAR_CHANGED));
		}
		
		public function get phaseOffset():Number {
			return _phaseOffset;
		}
		
		public function set phaseOffset(arg:Number):void {
			if (!isFinite(arg) || isNaN(arg)) return;
			_phaseOffset = arg;
			dispatchEvent(new Event(StarField.STAR_CHANGED));
		}
		
		public function get period():Number {
			return _period;
		}
		
		public function set period(arg:Number):void {
			if (!isFinite(arg) || isNaN(arg) || arg<=0) return;
			_period = arg;
			dispatchEvent(new Event(StarField.STAR_CHANGED));			
		}
		
		public function get functionUsed():String {
			return _functionUsed;
		}
		
		public function set functionUsed(arg:String):void {
			if (arg!=PulsatingStar.COSINE && arg!=PulsatingStar.SINE) return;
			_functionUsed = arg;
			dispatchEvent(new Event(StarField.STAR_CHANGED));			
		}
		
		public function get magnitude():Number {
			return _A0;
		}
		
		public function set magnitude(arg:Number):void {
			if (!isFinite(arg) || isNaN(arg)) return;
			_A0 = arg;
			dispatchEvent(new Event(StarField.STAR_CHANGED));
		}
		
		public function getFourierTermsList():Array {
			var copyList:Array = [];
			for (var i:int = 0; i<_termsList.length; i++) {
				copyList[i] = {A: _termsList[i].A, phi: _termsList[i].phi};
			}
			return copyList;
		}
		
		public function setFourierTermsList(arg:Array):void {
			var obj:Object;
			var copyList:Array = [];
			for (var i:int = 0; i<arg.length; i++) {
				obj = {};
				obj.A = arg[i].A;
				obj.phi = arg[i].phi;
				if (!(obj.A is Number) || isNaN(obj.A) || !isFinite(obj.A) ||
					!(obj.phi is Number) || isNaN(obj.phi) || !isFinite(obj.phi)) break;
				copyList[i] = obj;
			}
			if (copyList.length==0) {
				trace("no joy");
			}
			else {
				_termsList = copyList;
				dispatchEvent(new Event(StarField.STAR_CHANGED));
			}
		}
		
		public function getParamsObject(epoch:Number):StarParamsObject {
			var i:int;
			var func:Function = Math[_functionUsed];
			var sum:Number = _A0;
			var t:Number = (2*Math.PI)*(epoch-_phaseOffset)/_period;
			for (i=0; i<_termsList.length; i++)	sum += _termsList[i].A*func((i+1)*t + _termsList[i].phi);
			_paramsObj.magnitude = sum;
			return _paramsObj;
		}
		
	}
	
}
